/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class LutApplier
implements PlugInFilter {
    ImagePlus imp;
    int min;
    int max;
    boolean canceled;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        int baseOptions = 23;
        return baseOptions;
    }

    public void run(ImageProcessor ip) {
        this.apply(this.imp, ip);
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        if (ip.getMinThreshold() != -808080.0) {
            imp.unlock();
            IJ.runPlugIn("ij.plugin.Thresholder", "skip");
            return;
        }
        this.min = (int)imp.getDisplayRangeMin();
        this.max = (int)imp.getDisplayRangeMax();
        int depth = imp.getBitDepth();
        if ((depth == 8 || depth == 24) && this.min == 0 && this.max == 255) {
            IJ.error("Apply LUT", "The display range must first be updated\nusing Image>Adjust>Brightness/Contrast\nor threshold levels defined using\nImage>Adjust>Threshold.");
            return;
        }
        if (imp.getType() == 4) {
            if (imp.getStackSize() > 1) {
                this.applyRGBStack(imp);
            } else {
                ip.reset();
                Undo.setup(6, imp);
                ip.setMinAndMax(this.min, this.max);
            }
            ((ColorProcessor)ip).caSnapshot(false);
            this.resetContrastAdjuster();
            return;
        }
        ip.resetMinAndMax();
        int range = 256;
        if (depth == 16) {
            range = 65536;
            int defaultRange = imp.getDefault16bitRange();
            if (defaultRange > 0) {
                range = (int)Math.pow(2.0, defaultRange) - 1;
            }
        }
        int tableSize = depth == 16 ? 65536 : 256;
        int[] table = new int[tableSize];
        for (int i = 0; i < tableSize; ++i) {
            table[i] = i <= this.min ? 0 : (i >= this.max ? range - 1 : (int)((double)(i - this.min) / (double)(this.max - this.min) * (double)range));
        }
        ImageProcessor mask = imp.getMask();
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            int flags = IJ.setupDialog(imp, 0);
            if (flags == 4096) {
                ip.setMinAndMax(this.min, this.max);
                return;
            }
            if (flags == 32) {
                int current = imp.getCurrentSlice();
                for (int i = 1; i <= imp.getStackSize(); ++i) {
                    imp.setSlice(i);
                    ip = imp.getProcessor();
                    if (mask != null) {
                        ip.snapshot();
                    }
                    ip.applyTable(table);
                    ip.reset(mask);
                }
                imp.setSlice(current);
                Undo.reset();
            } else {
                ip.applyTable(table);
                ip.reset(mask);
            }
        } else {
            ip.applyTable(table);
            ip.reset(mask);
        }
        if (depth == 16) {
            imp.setDisplayRange(0.0, range - 1);
        }
        this.resetContrastAdjuster();
    }

    private void resetContrastAdjuster() {
        ContrastAdjuster.update();
    }

    void applyRGBStack(ImagePlus imp) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            this.canceled = true;
            return;
        }
        for (int i = 1; i <= n; ++i) {
            if (i == current) continue;
            imp.setSlice(i);
            ImageProcessor ip = imp.getProcessor();
            ip.setMinAndMax(this.min, this.max);
            IJ.showProgress((double)i / (double)n);
        }
        imp.setSlice(current);
    }
}

