/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class ScaleBar
implements PlugIn {
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static final String[] colors = new String[]{"White", "Black", "Light Gray", "Gray", "Dark Gray", "Red", "Green", "Blue", "Yellow"};
    static final String[] bcolors = new String[]{"None", "Black", "White", "Dark Gray", "Gray", "Light Gray", "Yellow", "Blue", "Green", "Red"};
    static final String[] checkboxLabels = new String[]{"Bold Text", "Hide Text", "Serif Font", "Overlay"};
    static final String SCALE_BAR = "|SB|";
    static double barWidth;
    static int defaultBarHeight;
    static int barHeightInPixels;
    static String location;
    static String color;
    static String bcolor;
    static boolean boldText;
    static boolean hideText;
    static boolean createOverlay;
    static int defaultFontSize;
    static int fontSize;
    static boolean labelAll;
    ImagePlus imp;
    double imageWidth;
    double mag;
    int xloc;
    int yloc;
    int barWidthInPixels;
    int roiX = -1;
    int roiY;
    int roiWidth;
    int roiHeight;
    boolean serifFont;
    boolean[] checkboxStates = new boolean[4];
    boolean showingOverlay;
    boolean drawnScaleBar;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp != null) {
            if (this.showDialog(this.imp) && this.imp.getStackSize() > 1 && labelAll) {
                this.labelSlices(this.imp);
            }
        } else {
            IJ.noImage();
        }
    }

    void labelSlices(ImagePlus imp) {
        if (createOverlay) {
            return;
        }
        ImageStack stack = imp.getStack();
        String units = this.getUnits(imp);
        for (int i = 1; i <= stack.getSize(); ++i) {
            this.drawScaleBar(stack.getProcessor(i), units);
        }
        imp.setStack(stack);
    }

    boolean showDialog(ImagePlus imp) {
        int digits;
        double pixelWidth;
        String units;
        Roi roi = imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            this.roiX = r.x;
            this.roiY = r.y;
            this.roiWidth = r.width;
            this.roiHeight = r.height;
            location = locations[4];
        } else if (location.equals(locations[4])) {
            location = locations[0];
        }
        Calibration cal = imp.getCalibration();
        ImageWindow win = imp.getWindow();
        double d = this.mag = win != null ? win.getCanvas().getMagnification() : 1.0;
        if (this.mag > 1.0) {
            this.mag = 1.0;
        }
        if ((double)fontSize < (double)defaultFontSize / this.mag) {
            fontSize = (int)((double)defaultFontSize / this.mag);
        }
        if ((units = cal.getUnits()).equals("micron")) {
            units = "\u00b5m";
        }
        if ((pixelWidth = cal.pixelWidth) == 0.0) {
            pixelWidth = 1.0;
        }
        double scale = 1.0 / pixelWidth;
        this.imageWidth = (double)imp.getWidth() * pixelWidth;
        if (this.roiX > 0 && this.roiWidth > 10) {
            barWidth = (double)this.roiWidth * pixelWidth;
        } else if (barWidth == 0.0 || barWidth > 0.67 * this.imageWidth) {
            barWidth = 80.0 * pixelWidth / this.mag;
            if (barWidth > 0.67 * this.imageWidth) {
                barWidth = 0.67 * this.imageWidth;
            }
            if (barWidth > 5.0) {
                barWidth = (int)barWidth;
            }
        }
        int stackSize = imp.getStackSize();
        int n = digits = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            digits = 2;
        }
        int percent = (int)(barWidth * 100.0 / this.imageWidth);
        if (this.mag < 1.0 && (double)barHeightInPixels < (double)defaultBarHeight / this.mag) {
            barHeightInPixels = (int)((double)defaultBarHeight / this.mag);
        }
        imp.getProcessor().snapshot();
        if (IJ.macroRunning()) {
            createOverlay = false;
            this.serifFont = false;
            hideText = false;
            boldText = false;
        } else {
            this.updateScalebar();
        }
        BarDialog gd = new BarDialog("Scale Bar");
        gd.addNumericField("Width in " + units + ": ", barWidth, digits);
        gd.addNumericField("Height in pixels: ", barHeightInPixels, 0);
        gd.addNumericField("Font size: ", fontSize, 0);
        gd.addChoice("Color: ", colors, color);
        gd.addChoice("Background: ", bcolors, bcolor);
        gd.addChoice("Location: ", locations, location);
        this.checkboxStates[0] = boldText;
        this.checkboxStates[1] = hideText;
        this.checkboxStates[2] = this.serifFont;
        this.checkboxStates[3] = createOverlay;
        gd.setInsets(10, 25, 0);
        gd.addCheckboxGroup(2, 2, checkboxLabels, this.checkboxStates);
        if (stackSize > 1) {
            gd.setInsets(0, 25, 0);
            gd.addCheckbox("Label all slices", labelAll);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            imp.getProcessor().reset();
            imp.updateAndDraw();
            Overlay overlay = imp.getOverlay();
            if (this.showingOverlay && overlay != null) {
                overlay.remove(SCALE_BAR);
                imp.draw();
            }
            return false;
        }
        barWidth = gd.getNextNumber();
        barHeightInPixels = (int)gd.getNextNumber();
        fontSize = (int)gd.getNextNumber();
        color = gd.getNextChoice();
        bcolor = gd.getNextChoice();
        location = gd.getNextChoice();
        boldText = gd.getNextBoolean();
        hideText = gd.getNextBoolean();
        this.serifFont = gd.getNextBoolean();
        createOverlay = gd.getNextBoolean();
        if (stackSize > 1) {
            labelAll = gd.getNextBoolean();
        }
        if (IJ.macroRunning()) {
            this.updateScalebar();
        }
        return true;
    }

    void drawScaleBar(ImagePlus imp) {
        if (!this.updateLocation()) {
            return;
        }
        Undo.setup(1, imp);
        this.drawScaleBar(imp.getProcessor(), this.getUnits(imp));
        imp.updateAndDraw();
    }

    String getUnits(ImagePlus imp) {
        String units = imp.getCalibration().getUnits();
        if (units.equals("microns")) {
            units = "\u00b5m";
        }
        return units;
    }

    void createOverlay(ImagePlus imp) {
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
        } else {
            overlay.remove(SCALE_BAR);
        }
        Color color = this.getColor();
        Color bcolor = this.getBColor();
        int x = this.xloc;
        int y = this.yloc;
        int fontType = boldText ? 1 : 0;
        String face = this.serifFont ? "Serif" : "SanSerif";
        Font font = new Font(face, fontType, fontSize);
        String label = this.getLength(barWidth) + " " + this.getUnits(imp);
        ImageProcessor ip = imp.getProcessor();
        ip.setFont(font);
        int swidth = hideText ? 0 : ip.getStringWidth(label);
        int xoffset = (this.barWidthInPixels - swidth) / 2;
        int yoffset = barHeightInPixels + (hideText ? 0 : fontSize + fontSize / 4);
        if (bcolor != null) {
            int margin;
            int x2;
            int w = this.barWidthInPixels;
            int h = yoffset;
            if (w < swidth) {
                w = swidth;
            }
            if (x + xoffset < (x2 = x)) {
                x2 = x + xoffset;
            }
            if ((margin = w / 20) < 2) {
                margin = 2;
            }
            int y2 = y - margin;
            Roi background = new Roi(x2 -= margin, y2, w += margin * 2, h += margin * 2);
            background.setFillColor(bcolor);
            overlay.add(background, SCALE_BAR);
        }
        Roi bar = new Roi(x, y, this.barWidthInPixels, barHeightInPixels);
        bar.setFillColor(color);
        overlay.add(bar, SCALE_BAR);
        if (!hideText) {
            TextRoi text = new TextRoi(x + xoffset, y + barHeightInPixels, label, font);
            text.setStrokeColor(color);
            overlay.add(text, SCALE_BAR);
        }
        imp.setOverlay(overlay);
        this.showingOverlay = true;
    }

    void drawScaleBar(ImageProcessor ip, String units) {
        Color color = this.getColor();
        Color bcolor = this.getBColor();
        int x = this.xloc;
        int y = this.yloc;
        int fontType = boldText ? 1 : 0;
        String font = this.serifFont ? "Serif" : "SanSerif";
        ip.setFont(new Font(font, fontType, fontSize));
        ip.setAntialiasedText(true);
        String label = this.getLength(barWidth) + " " + units;
        int swidth = hideText ? 0 : ip.getStringWidth(label);
        int xoffset = (this.barWidthInPixels - swidth) / 2;
        int yoffset = barHeightInPixels + (hideText ? 0 : fontSize + fontSize / (this.serifFont ? 8 : 4));
        if (bcolor != null) {
            int margin;
            int x2;
            int w = this.barWidthInPixels;
            int h = yoffset;
            if (w < swidth) {
                w = swidth;
            }
            if (x + xoffset < (x2 = x)) {
                x2 = x + xoffset;
            }
            if ((margin = w / 20) < 2) {
                margin = 2;
            }
            int y2 = y - margin;
            ip.setColor(bcolor);
            ip.setRoi(x2 -= margin, y2, w += margin * 2, h += margin * 2);
            ip.fill();
        }
        ip.resetRoi();
        ip.setColor(color);
        ip.setRoi(x, y, this.barWidthInPixels, barHeightInPixels);
        ip.fill();
        ip.resetRoi();
        if (!hideText) {
            ip.drawString(label, x + xoffset, y + yoffset);
        }
        this.drawnScaleBar = true;
    }

    String getLength(double barWidth) {
        String s;
        int digits;
        int n = digits = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            digits = 1;
        }
        if (digits == 1 && !(s = IJ.d2s(barWidth / 0.1, 2)).endsWith(".00")) {
            digits = 2;
        }
        return IJ.d2s(barWidth, digits);
    }

    boolean updateLocation() {
        Calibration cal = this.imp.getCalibration();
        this.barWidthInPixels = (int)(barWidth / cal.pixelWidth);
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int fraction = 20;
        int x = width - width / fraction - this.barWidthInPixels;
        int y = 0;
        if (location.equals(locations[0])) {
            y = height / fraction;
        } else if (location.equals(locations[1])) {
            y = height - height / fraction - barHeightInPixels - fontSize;
        } else if (location.equals(locations[3])) {
            x = width / fraction;
            y = height / fraction;
        } else if (location.equals(locations[2])) {
            x = width / fraction;
            y = height - height / fraction - barHeightInPixels - fontSize;
        } else {
            if (this.roiX == -1) {
                return false;
            }
            x = this.roiX;
            y = this.roiY;
        }
        this.xloc = x;
        this.yloc = y;
        return true;
    }

    Color getColor() {
        Color c = Color.black;
        if (color.equals(colors[0])) {
            c = Color.white;
        } else if (color.equals(colors[2])) {
            c = Color.lightGray;
        } else if (color.equals(colors[3])) {
            c = Color.gray;
        } else if (color.equals(colors[4])) {
            c = Color.darkGray;
        } else if (color.equals(colors[5])) {
            c = Color.red;
        } else if (color.equals(colors[6])) {
            c = Color.green;
        } else if (color.equals(colors[7])) {
            c = Color.blue;
        } else if (color.equals(colors[8])) {
            c = Color.yellow;
        }
        return c;
    }

    Color getBColor() {
        if (bcolor == null || bcolor.equals(bcolors[0])) {
            return null;
        }
        Color bc = Color.white;
        if (bcolor.equals(bcolors[1])) {
            bc = Color.black;
        } else if (bcolor.equals(bcolors[3])) {
            bc = Color.darkGray;
        } else if (bcolor.equals(bcolors[4])) {
            bc = Color.gray;
        } else if (bcolor.equals(bcolors[5])) {
            bc = Color.lightGray;
        } else if (bcolor.equals(bcolors[6])) {
            bc = Color.yellow;
        } else if (bcolor.equals(bcolors[7])) {
            bc = Color.blue;
        } else if (bcolor.equals(bcolors[8])) {
            bc = Color.green;
        } else if (bcolor.equals(bcolors[9])) {
            bc = Color.red;
        }
        return bc;
    }

    void updateScalebar() {
        this.updateLocation();
        this.imp.getProcessor().reset();
        if (createOverlay) {
            if (this.drawnScaleBar) {
                this.imp.updateAndDraw();
                this.drawnScaleBar = false;
            }
            this.createOverlay(this.imp);
        } else {
            if (this.showingOverlay) {
                this.imp.setOverlay(null);
                this.showingOverlay = false;
            }
            this.drawScaleBar(this.imp);
        }
    }

    static {
        barHeightInPixels = defaultBarHeight = 4;
        location = locations[1];
        color = colors[0];
        bcolor = bcolors[0];
        boldText = true;
        createOverlay = true;
        defaultFontSize = 14;
    }

    class BarDialog
    extends GenericDialog {
        BarDialog(String title) {
            super(title);
        }

        public void textValueChanged(TextEvent e) {
            TextField widthField = (TextField)this.numberField.elementAt(0);
            Double d = this.getValue(widthField.getText());
            if (d == null) {
                return;
            }
            barWidth = d;
            TextField heightField = (TextField)this.numberField.elementAt(1);
            d = this.getValue(heightField.getText());
            if (d == null) {
                return;
            }
            barHeightInPixels = (int)d.doubleValue();
            TextField fontSizeField = (TextField)this.numberField.elementAt(2);
            d = this.getValue(fontSizeField.getText());
            if (d == null) {
                return;
            }
            int size = (int)d.doubleValue();
            if (size > 5) {
                fontSize = size;
            }
            ScaleBar.this.updateScalebar();
        }

        public void itemStateChanged(ItemEvent e) {
            Choice col = (Choice)this.choice.elementAt(0);
            color = col.getSelectedItem();
            Choice bcol = (Choice)this.choice.elementAt(1);
            bcolor = bcol.getSelectedItem();
            Choice loc = (Choice)this.choice.elementAt(2);
            location = loc.getSelectedItem();
            boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            hideText = ((Checkbox)this.checkbox.elementAt(1)).getState();
            ScaleBar.this.serifFont = ((Checkbox)this.checkbox.elementAt(2)).getState();
            createOverlay = ((Checkbox)this.checkbox.elementAt(3)).getState();
            ScaleBar.this.updateScalebar();
        }
    }
}

