/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Label;
import java.util.Vector;

public class PointToolOptions
implements PlugIn,
DialogListener {
    private static GenericDialog gd = null;
    private boolean multipointTool;
    private static final String help = "<html><h1>Point Tool</h1><font size=+1><ul><li> Alt-click, or control-click, on a point to delete it.<br><li> Press 'y' (<i>Edit&gt;Selection&gt;Properties</i>) to display<br>the counts in a results table.<br><li> Press 'm' (<i>Analyze&gt;Measure</i>) to display the<br>point stack positions in the results table.<br><li> Use <i>File&gt;Save As&gt;Tiff</i> or <i>File&gt;Save As&gt;Selection</i><br>to save the points and counts.<br></ul> <br></font>";

    public void run(String arg) {
        if (gd != null && gd.isShowing()) {
            gd.toFront();
            PointToolOptions.update();
        } else {
            this.showDialog();
        }
    }

    void showDialog() {
        String options;
        String string = options = IJ.isMacro() ? Macro.getOptions() : null;
        if (options != null) {
            options = options.replace("selection=", "color=");
            options = options.replace("marker=", "size=");
            Macro.setOptions(options);
        }
        this.multipointTool = IJ.getToolName().equals("multipoint");
        Color sc = Roi.getColor();
        String sname = Colors.getColorName(sc, "Yellow");
        Color cc = PointRoi.getDefaultCrossColor();
        String cname = Colors.getColorName(cc, "None");
        String type = PointRoi.types[PointRoi.getDefaultType()];
        String size = PointRoi.sizes[PointRoi.getDefaultSize()];
        gd = this.multipointTool ? new NonBlockingGenericDialog("Point Tool") : new GenericDialog("Point Tool");
        gd.setInsets(5, 0, 2);
        gd.addChoice("Type:", PointRoi.types, type);
        gd.addChoice("Color:", Colors.getColors(new String[0]), sname);
        gd.addChoice("Size:", PointRoi.sizes, size);
        if (!this.multipointTool) {
            gd.addCheckbox("Auto-measure", Prefs.pointAutoMeasure);
            gd.addCheckbox("Auto-next slice", Prefs.pointAutoNextSlice);
            gd.addCheckbox("Add_to overlay", Prefs.pointAddToOverlay);
            gd.addCheckbox("Add to ROI Manager", Prefs.pointAddToManager);
        }
        gd.setInsets(5, 20, 0);
        gd.addCheckbox("Label points", !Prefs.noPointLabels);
        if (this.multipointTool) {
            gd.addCheckbox("Show all", Prefs.showAllPoints);
            gd.setInsets(15, 0, 5);
            String[] choices = PointRoi.getCounterChoices();
            gd.addChoice("Counter:", choices, choices[PointToolOptions.getCounter()]);
            gd.setInsets(2, 75, 0);
            gd.addMessage(PointToolOptions.getCount(PointToolOptions.getCounter()) + "    ");
        }
        gd.addHelp(help);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            // empty if block
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        PointRoi roi;
        boolean noPointLabels;
        String selectionColor;
        Color sc;
        boolean redraw = false;
        int index = gd.getNextChoiceIndex();
        if (index != PointRoi.getDefaultType()) {
            PointRoi.setDefaultType(index);
            redraw = true;
        }
        if ((sc = Colors.getColor(selectionColor = gd.getNextChoice(), Color.yellow)) != Roi.getColor()) {
            Roi.setColor(sc);
            redraw = true;
            Toolbar.getInstance().repaint();
        }
        if ((index = gd.getNextChoiceIndex()) != PointRoi.getDefaultSize()) {
            PointRoi.setDefaultSize(index);
            redraw = true;
        }
        if (!this.multipointTool) {
            Prefs.pointAutoMeasure = gd.getNextBoolean();
            Prefs.pointAutoNextSlice = gd.getNextBoolean();
            Prefs.pointAddToOverlay = gd.getNextBoolean();
            Prefs.pointAddToManager = gd.getNextBoolean();
            if (Prefs.pointAddToOverlay) {
                Prefs.pointAddToManager = false;
            }
            if (Prefs.pointAutoNextSlice && !Prefs.pointAddToManager) {
                Prefs.pointAutoMeasure = true;
            }
        }
        boolean bl = noPointLabels = !gd.getNextBoolean();
        if (noPointLabels != Prefs.noPointLabels) {
            redraw = true;
        }
        Prefs.noPointLabels = noPointLabels;
        if (this.multipointTool) {
            boolean showAllPoints = gd.getNextBoolean();
            if (showAllPoints != Prefs.showAllPoints) {
                redraw = true;
            }
            Prefs.showAllPoints = showAllPoints;
            int counter = gd.getNextChoiceIndex();
            if (counter != PointToolOptions.getCounter()) {
                PointToolOptions.setCounter(counter);
                redraw = true;
            }
        }
        if (redraw && (roi = PointToolOptions.getPointRoi()) != null) {
            roi.setShowLabels(!Prefs.noPointLabels);
            ImagePlus imp = roi.getImage();
            if (imp != null) {
                imp.draw();
            }
        }
        return true;
    }

    private static int getCounter() {
        PointRoi roi = PointToolOptions.getPointRoi();
        return roi != null ? roi.getCounter() : 0;
    }

    private static void setCounter(int counter) {
        PointRoi roi = PointToolOptions.getPointRoi();
        if (roi != null) {
            roi.setCounter(counter);
        }
        PointRoi.setDefaultCounter(counter);
    }

    private static PointRoi getPointRoi() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return null;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            return null;
        }
        if (roi instanceof PointRoi) {
            return (PointRoi)roi;
        }
        return null;
    }

    private static int getCount(int counter) {
        PointRoi roi = PointToolOptions.getPointRoi();
        return roi != null ? roi.getCount(counter) : 0;
    }

    public static void update() {
        if (gd != null && gd.isShowing()) {
            Vector choices = gd.getChoices();
            if (choices == null || choices.size() < 4) {
                return;
            }
            Choice counterChoice = (Choice)choices.elementAt(3);
            int counter = PointToolOptions.getCounter();
            int count = PointToolOptions.getCount(counter);
            counterChoice.select(counter);
            ((Label)gd.getMessage()).setText("" + count);
        }
    }
}

