/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.plugin.Colors;
import ij.plugin.OverlayLabels;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.text.TextWindow;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;

public class OverlayCommands
implements PlugIn {
    private static int opacity = 100;
    private static Roi defaultRoi = new Roi(0, 0, 1, 1);
    private static boolean zeroTransparent;

    public void run(String arg) {
        if (arg.equals("add")) {
            this.addSelection();
        } else if (arg.equals("image")) {
            this.addImage(false);
        } else if (arg.equals("image-roi")) {
            this.addImage(true);
        } else if (arg.equals("flatten")) {
            this.flatten();
        } else if (arg.equals("hide")) {
            this.hide();
        } else if (arg.equals("show")) {
            this.show();
        } else if (arg.equals("remove")) {
            this.remove();
        } else if (arg.equals("from")) {
            this.fromRoiManager();
        } else if (arg.equals("to")) {
            this.toRoiManager();
        } else if (arg.equals("list")) {
            this.list();
        } else if (arg.equals("options")) {
            this.options();
        }
    }

    void addSelection() {
        boolean brushRoi;
        String name;
        boolean points;
        ImagePlus imp = IJ.getImage();
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && IJ.macroRunning() && macroOptions.indexOf("remove") != -1) {
            imp.setOverlay(null);
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null && imp.getOverlay() != null) {
            GenericDialog gd = new GenericDialog("No Selection");
            gd.addMessage("\"Overlay>Add\" requires a selection.");
            gd.setInsets(15, 40, 0);
            gd.addCheckbox("Remove existing overlay", false);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            if (gd.getNextBoolean()) {
                imp.setOverlay(null);
            }
            return;
        }
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return;
        }
        roi = (Roi)roi.clone();
        Overlay overlay = imp.getOverlay();
        if (!roi.isDrawingTool()) {
            if (roi.getStroke() == null) {
                roi.setStrokeWidth(defaultRoi.getStrokeWidth());
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
        }
        boolean setPos = defaultRoi.getPosition() != 0;
        int stackSize = imp.getStackSize();
        if (setPos && stackSize > 1) {
            if (imp.isHyperStack() || imp.isComposite()) {
                int channel;
                boolean compositeMode = imp.isComposite() && ((CompositeImage)imp).getMode() == 1;
                int n = channel = !compositeMode || imp.getNChannels() == stackSize ? imp.getChannel() : 0;
                if (imp.getNSlices() > 1) {
                    roi.setPosition(channel, imp.getSlice(), 0);
                } else if (imp.getNFrames() > 1) {
                    roi.setPosition(channel, 0, imp.getFrame());
                }
            } else {
                roi.setPosition(imp.getCurrentSlice());
            }
        }
        boolean bl = points = roi instanceof PointRoi && ((PolygonRoi)roi).getNCoordinates() > 1;
        if (IJ.altKeyDown() || IJ.macroRunning() && Macro.getOptions() != null) {
            RoiProperties rp = new RoiProperties("Add to Overlay", roi);
            if (!rp.showDialog()) {
                return;
            }
            defaultRoi.setStrokeColor(roi.getStrokeColor());
            defaultRoi.setStrokeWidth(roi.getStrokeWidth());
            defaultRoi.setFillColor(roi.getFillColor());
        }
        boolean newOverlay = (name = roi.getName()) != null && name.equals("new-overlay");
        Roi roiClone = (Roi)roi.clone();
        if (roi.getStrokeColor() == null) {
            roi.setStrokeColor(Roi.getColor());
        }
        if (overlay == null || newOverlay) {
            overlay = OverlayLabels.createOverlay();
        }
        overlay.add(roi);
        defaultRoi.setPosition(setPos ? 1 : 0);
        imp.setOverlay(overlay);
        boolean bl2 = brushRoi = roi.getType() == 9 && Toolbar.getToolId() == 1 && Toolbar.getBrushSize() > 0;
        if (points || roi instanceof ImageRoi || roi instanceof Arrow && !Prefs.keepArrowSelections || brushRoi) {
            imp.deleteRoi();
        }
        Undo.setup(7, imp);
    }

    void addImage(boolean createImageRoi) {
        String title;
        ImagePlus imp = IJ.getImage();
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            IJ.error("Add Image...", "The command requires at least two open images.");
            return;
        }
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp2 = WindowManager.getImage(wList[i]);
            titles[i] = imp2 != null ? imp2.getTitle() : "";
        }
        int x = 0;
        int y = 0;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            Rectangle r = roi.getBounds();
            x = r.x;
            y = r.y;
        }
        int index = 0;
        if (wList.length == 2) {
            ImagePlus i1 = WindowManager.getImage(wList[0]);
            ImagePlus i2 = WindowManager.getImage(wList[1]);
            if (i2.getWidth() < i1.getWidth() && i2.getHeight() < i1.getHeight()) {
                index = 1;
            }
        } else if (imp.getID() == wList[0]) {
            index = 1;
        }
        String string = title = createImageRoi ? "Create Image ROI" : "Add Image...";
        if (IJ.isMacro()) {
            opacity = 100;
            zeroTransparent = false;
        }
        GenericDialog gd = new GenericDialog(title);
        if (createImageRoi) {
            gd.addChoice("Image:", titles, titles[index]);
        } else {
            gd.addChoice("Image to add:", titles, titles[index]);
            gd.addNumericField("X location:", x, 0);
            gd.addNumericField("Y location:", y, 0);
        }
        gd.addNumericField("Opacity (0-100%):", opacity, 0);
        gd.addCheckbox("Zero transparent", zeroTransparent);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        index = gd.getNextChoiceIndex();
        if (!createImageRoi) {
            x = (int)gd.getNextNumber();
            y = (int)gd.getNextNumber();
        }
        opacity = (int)gd.getNextNumber();
        zeroTransparent = gd.getNextBoolean();
        ImagePlus overlay = WindowManager.getImage(wList[index]);
        if (wList.length == 2) {
            ImagePlus i1 = WindowManager.getImage(wList[0]);
            ImagePlus i2 = WindowManager.getImage(wList[1]);
            if (i2.getWidth() < i1.getWidth() && i2.getHeight() < i1.getHeight()) {
                imp = i1;
                overlay = i2;
            }
        }
        if (overlay == imp) {
            IJ.error("Add Image...", "Image to be added cannot be the same as\n\"" + imp.getTitle() + "\".");
            return;
        }
        if (overlay.getWidth() > imp.getWidth() && overlay.getHeight() > imp.getHeight()) {
            IJ.error("Add Image...", "Image to be added cannnot be larger than\n\"" + imp.getTitle() + "\".");
            return;
        }
        if (createImageRoi && x == 0 && y == 0) {
            x = imp.getWidth() / 2 - overlay.getWidth() / 2;
            y = imp.getHeight() / 2 - overlay.getHeight() / 2;
        }
        roi = new ImageRoi(x, y, overlay.getProcessor());
        roi.setName(overlay.getShortTitle());
        if (opacity != 100) {
            ((ImageRoi)roi).setOpacity((double)opacity / 100.0);
        }
        ((ImageRoi)roi).setZeroTransparent(zeroTransparent);
        if (createImageRoi) {
            imp.setRoi(roi);
        } else {
            Overlay overlayList = imp.getOverlay();
            if (overlayList == null) {
                overlayList = new Overlay();
            }
            overlayList.add(roi);
            imp.setOverlay(overlayList);
            Undo.setup(7, imp);
        }
    }

    void hide() {
        ImagePlus imp = IJ.getImage();
        imp.setHideOverlay(true);
        RoiManager rm = RoiManager.getInstance();
        if (rm != null) {
            rm.runCommand("show none");
        }
    }

    void show() {
        RoiManager rm;
        ImagePlus imp = IJ.getImage();
        imp.setHideOverlay(false);
        if (imp.getOverlay() == null && (rm = RoiManager.getInstance()) != null && rm.getCount() > 1) {
            if (!IJ.isMacro()) {
                rm.toFront();
            }
            rm.runCommand("show all with labels");
        }
    }

    void remove() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            ImageCanvas ic = imp.getCanvas();
            if (ic != null) {
                ic.setShowAllList(null);
            }
            imp.setOverlay(null);
        }
    }

    void flatten() {
        int flags;
        ImagePlus imp = IJ.getImage();
        if (imp.getStackSize() > 1 || imp.getBitDepth() == 24) {
            Overlay overlay = imp.getOverlay();
            Overlay roiManagerOverlay = null;
            ImageCanvas ic = imp.getCanvas();
            if (ic != null) {
                roiManagerOverlay = ic.getShowAllList();
            }
            if (!(overlay != null || roiManagerOverlay != null || imp.isComposite() || IJ.macroRunning() && imp.getStackSize() == 1)) {
                IJ.error("Flatten", "Overlay or multi-channel image required");
                return;
            }
        }
        if ((flags = IJ.setupDialog(imp, 0)) == 4096) {
            return;
        }
        if (flags == 32) {
            if (!IJ.isJava16()) {
                IJ.error("Flatten Stack", "Java 1.6 required to flatten a stack");
                return;
            }
            this.flattenStack(imp);
            if (Recorder.record) {
                Recorder.recordCall("imp.flattenStack();");
            }
        } else {
            ImagePlus imp2 = imp.flatten();
            imp2.setTitle(WindowManager.getUniqueName(imp.getTitle()));
            imp2.show();
            if (Recorder.record) {
                Recorder.recordCall("imp2 = imp.flatten();");
            }
        }
    }

    void flattenStack(ImagePlus imp) {
        imp.flattenStack();
    }

    void fromRoiManager() {
        ImagePlus imp = IJ.getImage();
        RoiManager rm = RoiManager.getInstance2();
        if (rm == null) {
            IJ.error("ROI Manager is not open");
            return;
        }
        Roi[] rois = rm.getRoisAsArray();
        if (rois.length == 0) {
            IJ.error("ROI Manager is empty");
            return;
        }
        rm.moveRoisToOverlay(imp);
        imp.deleteRoi();
    }

    void toRoiManager() {
        ImagePlus imp = IJ.getImage();
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            IJ.error("Overlay required");
            return;
        }
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            if (Macro.getOptions() != null && Interpreter.isBatchMode()) {
                rm = Interpreter.getBatchModeRoiManager();
            }
            if (rm == null) {
                Frame frame = WindowManager.getFrame("ROI Manager");
                if (frame == null) {
                    IJ.run("ROI Manager...");
                }
                if ((frame = WindowManager.getFrame("ROI Manager")) == null || !(frame instanceof RoiManager)) {
                    return;
                }
                rm = (RoiManager)frame;
            }
        }
        if (overlay.size() >= 4 && overlay.get(3).getPosition() != 0) {
            Prefs.showAllSliceOnly = true;
        }
        rm.runCommand("reset");
        rm.setEditMode(imp, false);
        for (int i = 0; i < overlay.size(); ++i) {
            rm.add(imp, overlay.get(i), i + 1);
        }
        rm.setEditMode(imp, true);
        rm.runCommand("show all");
        imp.setOverlay(null);
    }

    void options() {
        boolean points;
        ImagePlus imp = WindowManager.getCurrentImage();
        Overlay overlay = null;
        Roi roi = null;
        if (imp != null) {
            overlay = imp.getOverlay();
            roi = imp.getRoi();
            if (roi != null) {
                roi = (Roi)roi.clone();
            }
        }
        if (roi == null) {
            roi = defaultRoi;
        }
        if (roi == null) {
            int size = imp != null ? imp.getWidth() : 512;
            roi = new Roi(0, 0, size / 4, size / 4);
        }
        if (!roi.isDrawingTool()) {
            if (roi.getStroke() == null) {
                roi.setStrokeWidth(defaultRoi.getStrokeWidth());
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && defaultRoi.getStrokeColor() != null) {
                roi.setStrokeColor(defaultRoi.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(defaultRoi.getFillColor());
            }
        }
        boolean bl = points = roi instanceof PointRoi && ((PolygonRoi)roi).getNCoordinates() > 1;
        if (points) {
            roi.setStrokeColor(Color.red);
        }
        roi.setPosition(defaultRoi.getPosition());
        RoiProperties rp = new RoiProperties("Overlay Options", roi);
        if (!rp.showDialog()) {
            return;
        }
        defaultRoi = roi;
    }

    void list() {
        ImagePlus imp = IJ.getImage();
        Overlay overlay = imp.getOverlay();
        if (overlay != null) {
            OverlayCommands.listRois(overlay.toArray());
        }
    }

    public static void listRois(Roi[] rois) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rois.length; ++i) {
            Rectangle r = rois[i].getBounds();
            String color = Colors.colorToString(rois[i].getStrokeColor());
            String fill = Colors.colorToString(rois[i].getFillColor());
            double strokeWidth = rois[i].getStrokeWidth();
            int digits = strokeWidth == (double)((int)strokeWidth) ? 0 : 1;
            String sWidth = IJ.d2s(strokeWidth, digits);
            int position = rois[i].getPosition();
            int c = rois[i].getCPosition();
            int z = rois[i].getZPosition();
            int t = rois[i].getTPosition();
            list.add(i + "\t" + rois[i].getName() + "\t" + rois[i].getTypeAsString() + "\t" + r.x + "\t" + r.y + "\t" + r.width + "\t" + r.height + "\t" + color + "\t" + fill + "\t" + sWidth + "\t" + position + "\t" + c + "\t" + z + "\t" + t);
        }
        String headings = "Index\tName\tType\tX\tY\tWidth\tHeight\tColor\tFill\tLWidth\tPos\tC\tZ\tT";
        new TextWindow("Overlay Elements", headings, list, 600, 400);
    }

    static {
        defaultRoi.setPosition(1);
    }
}

